//
//  GHDeviceTypes.h
//  Garmin Health
//
//  Created by Johnson, Garrett on 4/21/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#ifndef __GH_DEVICE_TYPES

#define __GH_DEVICE_TYPES

/**
 *  Specific device types supported. Can be combined using '|' when scanning.
 *  For GHDeviceSettings and GHDeviceSchema, more than one type is not supported.
 *  @note Not all of the listed devices are supported by the SDK. Please refer to
 *  your SDK documentation for the list of supported Garmin devices.
 */
typedef NS_OPTIONS(NSInteger, GHDeviceTypes) {
    
    /** Type for vívofit devices */
    GHDeviceTypeVivofit = 1 << 0,
    
    /** Type for vívofit 2 devices */
    GHDeviceTypeVivofit2 = 1 << 1,
    
    /** Type for vívofit 3 devices */
    GHDeviceTypeVivofit3 = 1 << 2,
    
    /** Type for vívofit jr. devices */
    GHDeviceTypeVivofitJr = 1 << 3,
    
   /** Type for vívosmart HR and vívosmart HR+ devices */
    GHDeviceTypeVivosmartHr = 1 << 4,
    
    /** Type for vívoactive HR devices */
    GHDeviceTypeVivoactiveHr = 1 << 5,
    
    /** Type for vívosmart 3 devices */
    GHDeviceTypeVivosmart3 = 1 << 6,
    
    /** Type for vívosport devices */
    GHDeviceTypeVivosport = 1 << 7,
    
    /** Type for vívoactive3 devices */
    GHDeviceTypeVivoactive3 = 1 << 8,
    
    /** Type for vívomove HR devices */
    GHDeviceTypeVivomoveHr = 1 << 9,
    
    /** Type for vívofit4 devices */
    GHDeviceTypeVivofit4 = 1 << 10,
    
    /** Type for fenix 5 devices */
    GHDeviceTypeFenix5 = 1 << 11,
    
    /** Type for fenix 5s devices */
    GHDeviceTypeFenix5s = 1 << 12,
    
    /** Type for fenix 5x devices */
    GHDeviceTypeFenix5x = 1 << 13,
    
    /** Type for vívoactive 3 Music devices */
    GHDeviceTypeVivoactive3m = 1 << 14,
    
    /** Type for Forerunner 645 devices */
    GHDeviceTypeForerunner645 = 1 << 15,
    
    /** Type for Forerunner 645 Music devices */
    GHDeviceTypeForerunner645m = 1 << 16,

    /** Type for vívosmart 4 devices */
    GHDeviceTypeVivosmart4 = 1 << 17,

    /** Type for Tactix Charlie devices */
    GHDeviceTypeTactixCharlie = 1 << 18,

    /** Type for Forerunner 35 devices */
    GHDeviceTypeForerunner35 = 1 << 19,

    /** Type for fenix 5 devices */
    GHDeviceTypeFenix5Plus = 1 << 20,

    /** Type for fenix 5s devices */
    GHDeviceTypeFenix5sPlus = 1 << 21,

    /** Type for fenix 5x devices */
    GHDeviceTypeFenix5xPlus = 1 << 22,

    /** Type for MARQ Driver devices */
    GHDeviceTypeMARQDriver = 1 << 23,

    /** Type for MARQ Aviator devices */
    GHDeviceTypeMARQAviator = 1 << 24,

    /** Type for MARQ Captain devices */
    GHDeviceTypeMARQCaptain= 1 << 25,

    /** Type for MARQ Expedition devices */
    GHDeviceTypeMARQExpedition = 1 << 26,

    /** Type for MARQ Athlete devices */
    GHDeviceTypeMARQAthlete = 1 << 27,

    /** Type for MARQ Commander devices */
    GHDeviceTypeMARQCommander = 1 << 28,

    /** Type for Quatix 5 devices */
    GHDeviceTypeQuatix5 = 1 << 29,

    /** Type for Instinct devices */
    GHDeviceTypeInstinct = 1 << 30,

    /** Type for Forerunner 245 devices */
    GHDeviceTypeForerunner245 = 1LL << 31,

    /** Type for Forerunner 245 Music devices */
    GHDeviceTypeForerunner245m = 1LL << 32,

    /** Type for Forerunner 945 devices */
    GHDeviceTypeForerunner945 = 1LL << 33,

    /** Type for Fenix 6 devices */
    GHDeviceTypeFenix6 = 1LL << 34,

    /** Type for Fenix 6 Pro devices */
    GHDeviceTypeFenix6Pro = 1LL << 35,

    /** Type for Fenix 6s devices */
    GHDeviceTypeFenix6s = 1LL << 36,

    /** Type for Fenix 6s Pro devices */
    GHDeviceTypeFenix6sPro = 1LL << 37,

    /** Type for Fenix 6x Pro devices */
    GHDeviceTypeFenix6xPro = 1LL << 38,

    /** Type for vivoactive 4 devices */
    GHDeviceTypeVivoactive4 = 1LL << 39,

    /** Type for vivoactive 4s devices */
    GHDeviceTypeVivoactive4s = 1LL << 40,

    /** Type for Venu devices */
    GHDeviceTypeVenu = 1LL << 41,

    /** Type for vivomove 3 devices */
    GHDeviceTypeVivomove3 = 1LL << 42,

    /** Type for vivomove 3s devices */
    GHDeviceTypeVivomove3s = 1LL << 43,

    /** Type for vivomove luxe devices */
    GHDeviceTypeVivomoveLuxe = 1LL << 44,

    /** Type for vivomove style devices */
    GHDeviceTypeVivomoveStyle = 1LL << 45,

    /** Type for active legacy devices */
    GHDeviceTypeVivoactive4Legacy = 1LL << 46,

    /** Type for cannondale devices */
    GHDeviceTypeCannondaleWheelSensor = 1LL << 47,
    
    /** Type for Tactix Delta devices */
    GHDeviceTypeTactixDelta = 1LL << 48,
    
    /** Type for Venu Sq devices */
    GHDeviceTypeVenuSq = 1LL << 49,

    /** Type for instinct Solar devices */
    GHDeviceTypeInstinctSolar = 1LL << 50,
    
    /** Type for Forerunner 745 devices */
    GHDeviceTypeForerunner745 = 1LL << 51,
    
    /** Type for Fenix 6 Pro Solar devices */
    GHDeviceTypeFenix6ProSolar = 1LL << 52,
    
    /** Type for Fenix 6s Pro Solar devices */
    GHDeviceTypeFenix6sProSolar = 1LL << 53,
    
    /** Type for Fenix 6x Pro Solar devices */
    GHDeviceTypeFenix6xProSolar = 1LL << 54,
    
    /** Type for Tactix Delta Solar devices */
    GHDeviceTypeTactixDeltaSolar = 1LL << 55,
    
    /** Type for Index S2 Scales */
    GHDeviceTypeIndexS2Scale = 1LL << 56
};

#endif
